/*------------------------------------------------------------------------------*
 * File Name: CallingOCFromLabTalkEx.c											*
 * Creation: BT & GJL 8/25/03													*
 * Purpose: OriginC Source C file containing CallingOCFromLabTalkEx.c examples.	*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>

// Casting of Arguments
void PrintNumeric(int ii)
{
	printf("The number is %d", ii);
}

// Passing numeric normally
double PassingNumericNormally(double d)
{
	return 2* d;
}

// Operating on Scalors and Vectors
double CallOnceForeachElement(double a, double b)
{
	return a + b;
}

// Passing Strings with and without Substitution 
void PassString(string str)
{
	printf("The string is \"%s\"\n", str);
}

// Passing Vectors by Reference
vector PassVectorByReference(vector& vIn, double f)
{
	return (vIn * f);
}

// Passing an Array of Strings
vector PassArrayOfStrings(vector<string> vIn)
{
	vector vOut(vIn.GetSize());
	for(int ii = 0; ii < vIn.GetSize(); ii++)
		vOut[ii] = vIn[ii].GetLength();        
	return vOut;
}

// Returning a String
string GetErrorMessage(int iErrorCode)
{
	string str;
	str.Format("Error message %d", iErrorCode);
	return str;
}

// Returning a Vector
vector ReturnAVector(double f)
{
	vector vData = {0, 1, 2, 3, 4};
	return (vData * f);
}

void tt()
{
	vector vv(5);
	vv = ReturnAVector(12);
}

// returning double
double ReturningDouble(double a)
{
	return 2 * a;
}

bool matrix_multiply(const matrix& mat1, const matrix& mat2, matrix& matRet)
{
	if( mat1.GetNumCols() != mat2.GetNumRows() )
		return false;

	matRet = mat1 * mat2;

	printf("For result matrix: Mean = %f, Median = %f\nMin = %f, Max = %f\n", matRet.GetMean(), matRet.GetMedian(), matRet.GetMin(), matRet.GetMax());
	return true;
}


bool matrix_transpose(matrix& mat)
{
	return mat.Transpose();
}


void MedianFilter_ex(const Matrix & Mat1, Matrix & Mat2)
{
    BOOL rc;

    Mat2 = Mat1;
    rc = Mat2.MedianFilter(32); // default is MFILTER_ZEROPADDINGWINDOW
    if(rc)
    	printf("Observe the MedianFiltered matrix window %s from %s. (Option:ZEROPADDINGWINDOW (default))\n", Mat2.GetName(),Mat1.GetName());
    else
        printf("Error: MedianFilter on a matrix failed. (Option:ZEROPADDINGWINDOW (default))\n");
}


//assume Matrix1(datatype: double) contains data, Matrix2(datatype: long) exists
void ocmath_lu_ex(Matrix & matIO, Matrix<long> & matIPIV)
{
    int m = matIO.GetNumRows();
    int n = matIO.GetNumCols();
    matIPIV.SetSize(min(m,n), 1);
    ocmath_lu(matIO, matIPIV, m, n);
}